<?php

// Doczenie klasy pakietu PEAR
require_once('Text/CAPTCHA.php');

// Ustalanie opcje generowanego tekstu
$opts = array(
    'font_size' => 25,
    'font_path' => './',
    'font_file' => 'VeraMono.TTF'
);

// Tworzenie obiektu CAPTCHA
$cap = Text_CAPTCHA::factory('Image');

// Inicjowanie obiektu CAPTCHA cakowicie losowym tekstem
$r = $cap->init(250,100, null, $opts);

// Sprawdzenie, czy obiekt CAPTCHA jest prawidowy
if (PEAR::isError($r))
{
  echo 'Nie udao si wygenerowa testu CAPTCHA.';
  exit;
}

// Generowanie obrazka PNG
$png = $cap->getCAPTCHAAsPNG();

// Wywietlenie obrazka w przegldarce
header('Content-type: image/png');
echo $png;

?>
